<?php

namespace App\Console\Commands;

use App\Models\OrderGrouping;
use App\Models\OrderGroupingDetail;
use App\Models\OrderSchedule;
use Illuminate\Console\Command;
use DB;

class OrderGroupingDetailCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'order_grouping_detail:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Order Grouping Detail Cron';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        // return 0;

        // DB::transaction(function()
        // {
        //     $orderSchedules = OrderSchedule::select('pickup_city','pickup_location_id','pickup_postal_code','order_type','pickup_date','pickup_time_id','pickup_address')->selectRaw("SUM(quantity) as pickup_quantity")->selectRaw("Count(*) as order_count")->where('status',0)->whereColumn('pickup_location_id','drop_location_id')->groupBy('pickup_city','pickup_location_id','pickup_postal_code','order_type','pickup_date','pickup_time_id','pickup_address')->get();
           
        //     \Log::info("ordergroupingdetails".$orderSchedules);
        //     if(count($orderSchedules) > 0)
        //     {                                  
        //         $orderGroup = OrderGroupingDetail::createOrderGroupingDetail($orderSchedules); 
        //         \Log::info("ordergroupingdetails".$orderGroup);          
        //     }
        //     else
        //     {
        //         dd("Insert Error :");
        //     }
            
        // });

         DB::transaction(function()
        {
            $orderGroupingDetails = OrderGroupingDetail::where('order_type',1)->where('pickup_time_id',1)->where('status',0)->get();
           
            // \Log::info("ordergroupingdetails".$orderGroupingDetails);
            
            if(count($orderGroupingDetails)>0)
            {
                $total_pickup_quantity = 0 ;
                $groupingQuantityArray = [];
                $groupingIds = [];
                foreach($orderGroupingDetails as $orderGroupingDetail)
                {
                   if($total_pickup_quantity <= 12)
                   {             
                        
                        
                            $groupingQuantityArray[] = $orderGroupingDetail->pickup_quantity;
                        
                            $groupingIds[] = $orderGroupingDetail->order_grouping_detail_id;
                            $total_pickup_quantity = array_sum($groupingQuantityArray);
                        
                   }else{

                        array_pop( $groupingQuantityArray);
                        array_pop( $groupingIds);

                        $total_pickup_quantity = $total_pickup_quantity - $orderGroupingDetail->pickup_quantity;
                   }
                  
                }

                \Log::info("total_pickup_quantity".$total_pickup_quantity);
            }
            
        });
    }
}
